package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;


/** 
 * Menu action for retrieving a previously viewed file quickly and easily.
 * 
 * @author Kevin Green 2006
 * @author Vera Ranieri 2006
 * @since 2006-07-13 Kevin Green
 * @version 2006-08-03 Vera Ranieri
 */
public class RecentFileAction extends AbstractAction {

	/**
	 * String representation of the file
	 */
	String _file;
	
	/**
	 * Constructor accepting one file
	 * @param file The file to be opened
	 */
	public RecentFileAction(String file) {
		super(file);		
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Open the recent file");
		_file = file; 
	}
	/**
	 * Records if the file has been chosen to be opened
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		if(Easik.getInstance().getFrame().getSketch().getDirty()){

			int choice = JOptionPane.showConfirmDialog(null, "Unsaved changes will be lost.  Continue anyway?", 
							"Warning", JOptionPane.WARNING_MESSAGE);
			if(choice == JOptionPane.CANCEL_OPTION)
				return;
			
		}
		File selFile = new File((String)_file);
			
		if(selFile != null) {
			Easik.getInstance().getFrame().getSketch().loadFromXML( selFile );
			Easik.getInstance().getFrame().getSketch().setFile( selFile );
			Easik.getInstance().getIni().setLastUsedFolder( selFile.getAbsolutePath() );
			Easik.getInstance().getFrame().getSketch().setDirty(false);
			Easik.getInstance().getIni().addRecentFile(selFile);
		}
	}
}